IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Controladores_Lectores' AND xtype='U')
BEGIN
	CREATE TABLE CD_Controladores_Lectores 
	(
        Id_Lector			INT IDENTITY(1,1) NOT NULL,
		Activo				TINYINT,							/*0 = Inactivo, 1 = Activo*/
		Id_Controlador		SMALLINT NOT NULL,
		Sentido_Acceso		CHAR(1) NOT NULL,					/*E: Entrada / S: Salida / A: Entrada y Salida*/
		Tipo_Lector			VARCHAR(20) NOT NULL,				/*Anexo 1*/
		Tipo_Conversion		VARCHAR(10) NOT NULL,				/*Anexo 2*/
		Source_Id			VARCHAR(50),						/*Anexo 3*/
		Fabricante			VARCHAR(50),
		Observacion			VARCHAR(8000)

		CONSTRAINT PK_CCLE_PorId PRIMARY KEY CLUSTERED (Id_Lector ASC)
    )
END
GO

ALTER TABLE CD_Controladores_Lectores ADD CONSTRAINT FK_CCLE_CD_Controladores FOREIGN KEY(Id_Controlador)
	REFERENCES dbo.CD_Controladores (Id_Controlador)
GO

/*
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

ANEXO 1

Tipo_Lector:

* LECTORES CREDENCIALES:
CREMIFARE
CREMNTAG
CREMARIN
CREHID
CREICLASS
CREINDALA
CRETAGUHF

* LECTORES BIOMETRICOS:
BIOLH4000

* LECTORES QR/DNI:
QRDNI
QRTXT
CODBAR1D
QRURL

* LECTORES PAD NUMERICO:
PADNUM

-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

ANEXO 2

Tipo_Conversion:

H08		= 08 caracteres Hexadecimal (En la base de datos esta grabado en Hexadecimal, si viene en decimal hay que convertirlo a Hexa. Ej: 527589890 = 0262721F)
H14		= 14 caracteres Hexadecimal (En la base de datos esta grabado en Hexadecimal, si viene en decimal hay que convertirlo a Hexa. Ej: 527589890 = AABB040262721F)
D10		= 10 caracteres Decimal (En la base de datos esta grabado en Decimal con ceros adelante, si viene en decimal hay que agregarlo ceros a la izquierda hasta completar 10)
D		= caracteres Decimales (En la base de datos esta grabado en Decimal, no hay que convertir nada porque no tiene ceros a la izquierda)

-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

ANEXO 3

Source_Id:

Segn Informe mail 04/08/2021 Intelektron
source_id	Descripcin					Bornera API-4000		Interface Web API-4000			Bornera REIIN2			Interface Web REIIN2
0			Lector Credenciales	1		1						Lec Principal-A					1						Lector 2 (Externo) 
1			Lector Credenciales	2		2						Lec Principal-B					2						Lector 1 (Interno)
2			Lector Credenciales	3		3						Lec Expansin 1-A				No existe				No existe
3			Lector Credenciales	4		8						Lec Expansin 1-B				No existe				No existe
4			Biometrico 1				4						Biometrico 1					4						Biometrico 1
5			Teclado del IN2				No existe				No existe						5						Teclado
6			Biometrico 2				6						Biometrico 2					No existe				No existe
7			Biometrico 3				7						Biometrico 3					No existe				No existe
8			Lector Credenciales	5		9						Lec Expansin 2-A				No existe				No existe
9			Lector Credenciales 6		10						Lec Expansin 2-B				No existe				No existe
10			Lector Credenciales 7		11						Lec Expansin 3-A				No existe				No existe
11			Lector Credenciales 8		12						Lec Expansin 3-B				No existe				No existe


-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
